(DEFUN recover(msg) ;olderr cmd blip snapang othmode
  (REDRAW)
  (if (/= light$cmd nil)
    (SETVAR "CMDECHO" light$cmd))
  (if (/= light$blip nil)
    (SETVAR "BLIPMODE" light$blip))
  (if (/= light$snapang nil)
    (SETVAR "SNAPANG" light$snapang))
  (if (/= light$othmode nil)
    (SETVAR "ORTHOMODE" light$othmode))
  (if (/= light$txtstyle nil)
   (setvar "TEXTSTYLE" light$txtstyle))
    (SETQ *error* light$olderr)
    (princ)
)

(DEFUN C:TS_DTLSYM1( / ps ptlist direct last getnext sym_code sect_symdraw)
   (SETQ light$cmd (GETVAR "CMDECHO"))
   (SETQ light$blip (GETVAR "BLIPMODE"))
   (SETQ light$snapang (GETVAR "SNAPANG"))
   (SETQ light$othmode (GETVAR "ORTHOMODE"))
   (SETQ light$olderr *error* *error* recover)
   (SETQ scale (GETVAR "DIMSCALE"))
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)

   (COMMAND "_UNDO" "G")
   (SETQ ps (GETPOINT "\n :"))
   (SETQ direct (GETANGLE "\n ͼ:" ps))
   (SETVAR "SNAPANG" direct)
   (SETVAR "ORTHOMODE" 1)
   (SETQ last ps getnext 1)
   (SETQ ptlist (LIST ps))
   (WHILE (/= getnext nil)
      (INITGET 0 "End Undo")
      (SETQ getnext (GETPOINT "\n<E>/U/йյ:" last))
      (IF (/= getnext nil)
        (IF (/= (TYPE getnext) 'STR)
          (PROGN
            (GRDRAW last getnext -1 0)
            (SETQ ptlist (APPEND ptlist (LIST getnext)))
            (SETQ last getnext)
           )
          (PROGN
            (if (= "End" getnext)
               (SETQ getnext nil)
               (PROGN
                  (SETQ ptlist (REVERSE ptlist))
                  (SETQ ptlist (CDR ptlist))
                  (GRDRAW last (CAR ptlist) -1 0)
                  (SETQ last (CAR ptlist))
                  (SETQ ptlist (REVERSE ptlist))
               )
            )
		  )
        )
       )
    )
    (IF (> (LENGTH ptlist) 1)
      (PROGN
        (SETQ sym_code (GETSTRING "\n<1>:"))
        (IF (OR (= sym_code nil) (= sym_code ""))
            (SETQ sym_code "1")
         )
        (SETQ sect_symdraw (GETSTRING "\nͼ<>:"))
        (section_symdraw direct ptlist sym_code sect_symdraw)
      )
    )
    (COMMAND "_REDRAW")
   (COMMAND "_UNDO" "E")
    (SETVAR "CMDECHO" light$cmd)
    (SETVAR "BLIPMODE" light$blip)
    (SETVAR "SNAPANG" light$snapang)
    (SETVAR "ORTHOMODE" light$othmode)
    (SETQ *error* light$olderr)
    (princ)
)
(DEFUN sect_sym(current last next scale direct symcode / len1 len2 wide
                  entlist point curang)
   (SETQ curang (ANGLE current next))
   (IF (< (ABS (SIN (- direct curang))) 1E-5)
	   (PROGN
                 (SETQ len1 9.5 len2 5.5)
                 (IF (/= symcode nil)
                   (sect_text1 current last symcode scale)
                 )
		)
	   (PROGN
                 (SETQ len1 5.5 len2 9.5)
                 (IF (/= symcode nil)
                   (sect_text1 current next symcode scale)
                 )
           )
   )
   (SETQ wide (* 0.5 scale))
   (SETQ entlist (LIST
          (CONS 0 "POLYLINE")
          (CONS 8 "SYMBLE$")
          (LIST 10 0.0 0.0 0.0)
          (CONS 40 wide)
          (CONS 41 wide)
          (CONS 70 0)
          )
   )
   (ENTMAKE entlist)
   (SETQ point (POLAR current (ANGLE current last) (* len1 scale)))
   (SETQ entlist (LIST
		  (CONS 0 "VERTEX")
		  (CONS 10 point)
	 )
   )
   (ENTMAKE entlist)
   (SETQ entlist (LIST
		  (CONS 0 "VERTEX")
		  (CONS 10 current)
	 )
   )
   (ENTMAKE entlist)
   (SETQ point (POLAR current (ANGLE current next) (* len2 scale)))
   (SETQ entlist (LIST
		  (CONS 0 "VERTEX")
		  (CONS 10 point)
	 )
	)
   (ENTMAKE entlist)
   (SETQ entlist (LIST
		  (CONS 0 "SEQEND")
                  (CONS 8 "SYMBLE$")
	 )
   )
   (ENTMAKE entlist)
)

(DEFUN sect_text1(current direct code scale / point height entlist)
   (SETQ point (POLAR current (ANGLE current direct) (* -5 scale)))
   (SETQ height (* 3.5 scale))
   (SETQ entlist (LIST
		  (CONS 0 "TEXT")
          (CONS 8 "SYMBLE$")
          (CONS 10 point)
          (CONS 1 code)
          (CONS 40 height)
          (CONS 50 0.0)
          (CONS 7 (GETVAR "TEXTSTYLE"))
          (CONS 72 1)
          (CONS 11 point)
	 )
   )
   (ENTMAKE entlist)
)

(DEFUN sect_text2(current direct code scale style)
   (SETQ point (POLAR current (ANGLE current direct) (* 10.0 scale)))
   (SETQ height (* 3.5 scale))
   (SETQ entlist (LIST
		  (CONS 0 "TEXT")
		  (CONS 8 "SYMBLE$")
		  (CONS 10 point)
		  (CONS 40 height)
		  (CONS 1 code)
		  (CONS 50 0.0)
                  (CONS 7 style)
		  (CONS 72 4)
		  (CONS 11 point)
	  )
	)
   (ENTMAKE entlist)
)

(DEFUN section_symdraw(direct ptlist symcode sect_symdraw / osmode scale
             start point nums num last next current ps_data entlist)
    (SETQ osmode (GETVAR "OSMODE"))
    (SETVAR "OSMODE" 0)
    (SETQ scale (GETVAR "DIMSCALE"))
    (SETQ start (CAR ptlist))

    (SETQ entlist (LIST
           (CONS 0 "BLOCK")
           (CONS 8 "SYMBLE$")
           (CONS 10 start)
           (CONS 2 "*SECTSYM")
           (CONS 70 1)
         )
    )
    (ENTMAKE entlist)

    (SETQ last (POLAR start direct 100.0))
    (sect_sym start last (CADR ptlist) scale direct nil)
    (sect_text2 start last symcode scale "complex")
    (SETQ nums (- (LENGTH ptlist) 2) num 1)
    (SETQ current (CADR ptlist))
    (REPEAT nums
          (sect_sym (nth num ptlist) (nth (- num 1) ptlist)
                      (nth (+ num 1) ptlist) scale direct symcode)
          (SETQ num (+ num 1))
     )
    (SETQ current (CAR (REVERSE ptlist)))
    (SETQ last (CADR (REVERSE ptlist)))
    (SETQ next (POLAR current direct 100.0))
    (sect_sym current last next scale direct nil)
    (sect_text2 current next symcode scale "complex")
    (SETQ entlist (LIST
           (CONS 0 "ENDBLK")
         )
    )
    (SETQ blknam (ENTMAKE entlist))

    (SETQ nums (+ nums 2) num 0)
    (REGAPP "TS_LIGHT")
    (SETQ pt_data (LIST "TS_LIGHT"
               (CONS 1070 12000)
               (CONS 1000 "SECTION_SYMBLE")
               (CONS 1070 20013)
               (CONS 1040 direct)
               (CONS 1070 20011)
               (CONS 1000 symcode)
               (CONS 1070 20012)
               (CONS 1002 "{")
         )
    )

    (REPEAT nums
      (setq point (NTH num ptlist))
      (SETQ x (- (car point) (car start)))
      (SETQ y (- (cadr point) (cadr start)))
      (SETQ point (LIST x y 0.0))
      (SETQ pt_data (APPEND pt_data (LIST (CONS 1010 point))))
      (SETQ num (+ 1 num))
    )
    (SETQ pt_data (APPEND pt_data (LIST (CONS 1002 "}"))))

    (SETQ entlist (LIST
           (CONS 0 "INSERT")
           (CONS 10 start)
           (CONS 2 blknam)
           (CONS 8 "SYMBLE$")
           (LIST -3 pt_data)
      )
    )
    (ENTMAKE entlist)

    (IF (AND (/= sect_symdraw nil) (/= sect_symdraw ""))
       (PROGN
		 (SETQ next (POLAR start direct -100.0))
		 (sect_text2 start next sect_symdraw scale "HZ")
		)
	)

	(SETVAR "OSMODE" osmode)
)

(DEFUN C:TS_DTLSYM2( / ps pe direct sym_code)
   (SETQ light$cmd (GETVAR "CMDECHO"))
   (SETQ light$blip (GETVAR "BLIPMODE"))
   (SETQ light$snapang (GETVAR "SNAPANG"))
   (SETQ light$othmode (GETVAR "ORTHOMODE"))
   (SETQ light$olderr *error* *error* recover)
   (SETQ scale (GETVAR "DIMSCALE"))
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)

   (COMMAND "_UNDO" "G")
   (SETQ ps (GETPOINT "\n ():"))
   (SETQ pe (GETPOINT "\n ()յ:" ps))
   (SETQ direct (GETINT "\n ͼ(1/ 2/)<1>:"))
   (IF (OR (= direct nil) (= direct ""))
       (SETQ direct 1)
   )
   (SETQ sym_code (GETSTRING "\n<1>:"))
   (IF (= sym_code "")
       (SETQ sym_code "1")
   )

   (section_sym2draw ps pe direct sym_code)

   (COMMAND "_UNDO" "E")
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "SNAPANG" light$snapang)
   (SETVAR "ORTHOMODE" light$othmode)
   (SETQ *error* light$olderr)
   (princ)
)

(DEFUN section_sym2draw(ps pe direct symcode)
    (SETQ osmode (GETVAR "OSMODE"))
    (SETVAR "OSMODE" 0)
    (SETQ scale (GETVAR "DIMSCALE"))
    (SETQ len (* 8 scale))
    (SETQ pt1 (POLAR ps (ANGLE ps pe) len))
    (SETQ pt2 (POLAR pe (ANGLE pe ps) len))

    (SETQ entlist (LIST
           (CONS 0 "BLOCK")
           (CONS 8 "SYMBLE$")
          (CONS 10 ps)
           (CONS 2 "*SECTSYM")
           (CONS 70 1)
         )
    )
    (ENTMAKE entlist)
    (sect2_draw ps pt1 scale direct symcode)
    (sect2_draw pe pt2 scale direct symcode)
    (SETQ entlist (LIST
           (CONS 0 "ENDBLK")
         )
    )
    (SETQ blknam (ENTMAKE entlist))
    (SETQ pt_data (LIST "TS_LIGHT"
			   (CONS 1070 12000)
			   (CONS 1000 "BREAK_SYMBLE")
			   (CONS 1070 20021)
			   (CONS 1000 symcode)
			   (CONS 1070 20022)
			   (CONS 1010 ps)
			   (CONS 1070 20023)
			   (CONS 1010 pe)
			)
	 )
    (SETQ entlist (LIST
           (CONS 0 "INSERT")
           (CONS 10 ps)
           (CONS 2 blknam)
           (CONS 8 "SYMBLE$")
           (LIST -3 pt_data)
      )
    )
    (ENTMAKE entlist)
)

(DEFUN sect2_draw(ps pe scale direct symcode)
   (SETQ wide (* 0.5 scale))
   (SETQ entlist (LIST
		  (CONS 0 "POLYLINE")
		  (CONS 8 "SYMBLE$")
		  (LIST 10 0.0 0.0 0.0)
		  (CONS 40 wide)
		  (CONS 41 wide)
                  (CONS 70 0)
          )
   )
   (ENTMAKE entlist)
   (SETQ entlist (LIST
		  (CONS 0 "VERTEX")
                  (CONS 10 ps)
	 )
   )
   (ENTMAKE entlist)
   (SETQ entlist (LIST
		  (CONS 0 "VERTEX")
                  (CONS 10 pe)
	 )
   )
   (ENTMAKE entlist)
   (SETQ entlist (LIST
		  (CONS 0 "SEQEND")
                  (CONS 8 "SYMBLE$")
	 )
   )
   (ENTMAKE entlist)
   (SETQ point (POLAR ps direct (* 6 scale)))
   (SETQ h (* 5 scale))
   (SETQ ang (ANGLE ps pe))
   (IF (> (ABS (SIN ang)) 0.707)
        (IF (= direct 1)
              (SETQ point (LIST (- (car ps) h) (cadr ps)))
              (SETQ point (LIST (+ (car ps) h) (cadr ps)))
        )
        (IF (= direct 1)
              (SETQ point (LIST (car ps) (+ (cadr ps) h)))
              (SETQ point (LIST (car ps) (- (cadr ps) h)))
        )
   )
   (SETQ h (* 3.5 scale))
   (SETQ entlist (LIST
		  (CONS 0 "TEXT")
		  (CONS 8 "SYMBLE$")
		  (CONS 10 point)
                  (CONS 40 h)
                  (CONS 1 symcode)
		  (CONS 50 0.0)
                  (CONS 7 (GETVAR "TEXTSTYLE"))
                  (CONS 72 1)
		  (CONS 11 point)
	  )
	)
   (ENTMAKE entlist)
)

(DEFUN C:TS_DTLSYM3( / p1 p2 p3 p4 h wide ent1 ent2 entpl blknam
              code1 code2 stdcode addb)
   (SETQ light$cmd (GETVAR "CMDECHO"))
   (SETQ light$blip (GETVAR "BLIPMODE"))
   (SETQ light$osmode (GETVAR "OSMODE"))
   ;(SETQ light$olderr *error* *error* recover)
   (SETQ scale (GETVAR "DIMSCALE"))
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)

   (initget 1)
   (SETQ p1 (GETPOINT "\n:"))
   (initget 1)
   (SETQ p2 (GETPOINT "\nյ:" p1))
   (grdraw p1 p2 -1)
   (initget 1)
   (SETQ p3 (GETPOINT "\nλ:" p2))
   (grdraw p2 p3 -1)
   (setq p3 (list (car p3) (cadr p2)))
   (setq data_list (get_data))
   (setq code1 (nth 0 data_list) code2 (nth 1 data_list)
            stdcode (nth 2 data_list) addb (nth 3 data_list))
   (if (OR (= code2 nil) (= code2 ""))
		(setq code2 "-"))
   (setq h (* 3.0 scale) offset (* 5.0 scale))
   (if (and (/= stdcode "") (/= stdcode nil))
	 (progn
                (setq len1 (* (+ (strlen stdcode) 2) h))
		(setq len2 (- (car p3) (car p2) offset))
		(if (and (< (abs len2) len1) (> len2 0))
			  (setq p3 (list (+ (car p3) len1) (cadr p3))))
		(if (and (< (abs len2) len1) (< len2 0))
			  (setq p3 (list (- (car p3) len1) (cadr p3))))
	 )
   )
   (setq p4 (POLAR p3 (ANGLE p3 p2) offset))

   (command "_PLINE" p1 "W" 0.0 0.0 p2 p4 "")
   (setq blknam (strcat (ts_getenv "libs") "detail-1"))
   (command "insert" blknam p3 scale scale "0" code1 code2)
   (setq p4 (list (/ (+ (car p2) (car p4)) 2) (cadr p2)))
   (setvar "cmdecho" 0)
   (if (AND (/= stdcode nil) (/= stdcode ""))
         (command "text" "BC" p4 h 0 stdcode))
   (if (= addb "1")
      (progn
         (setq p4 (Polar p1 (+ (/ PI 2) (ANGLE p1 p2)) (/ h 3)))
         (SETQ P3 (POLAR P4 (angle P1 P2) (* 7 scale)))
         (setq wide (* 0.5 scale))
         (command "_PLINE" p4 "W" wide wide p3 "")
         (setq ent1 (entlast))
         (setq p4 (Polar p1 (- (ANGLE p1 p2) (/ PI 2)) (/ h 3)))
         (SETQ P3 (POLAR P4 (angle P1 P2) (* 7 scale)))
         (setq wide (* 0.5 scale))
         (command "_PLINE" p4 "W" wide wide p3 "")
         (setq ent2 (entlast))
         (initget 1)
         (setq entpl nil)
         (while (and (not (eq entpl ent1)) (not (eq entpl ent2)))
            (setq entpl (CAR (entsel "\nѡӷ")))
          )
         (entdel entpl)
         (entdel ent1)
         (entdel ent2)
      )
   )
    (REDRAW)
    (SETVAR "CMDECHO" light$cmd)
    (SETVAR "BLIPMODE" light$blip)
    (SETVAR "OSMODE" light$osmode)
   (princ)
)
(defun get_detail1( / data1)
   (setq data1 nil data1 (get_tile "code_t"))
   (if (and (/= data1 "") (/= data1 nil))
       ads_done_dialog()
   )
)
(defun hztxtnum (txt / sum i num)
   (setq sum (strlen txt))
   (setq i 1 num sum)
   (while (<= i sum)
      (if (> (ascii (substr txt i 1)) 127)
          (progn
          (setq num (- num 1))
          (setq i (+ i 2))
          )
          (setq i (+ i 1))
      )

   )
   (setq num num)
)
;----------------------------LT1----------------------------------------------
(DEFUN C:ts_dtlsym5( / scale txtsize txth p1 p2 p2c p3 ptxt txt a0 a1 a2 a3 x y dist disttxt)
   (setq light$cmd (GETVAR "CMDECHO"))
   (setq light$blip (GETVAR "BLIPMODE"));
   (setq light$osmode (GETVAR "OSMODE"))
   (setq light$othmode (getvar "ORTHOMODE"))
   (setq light$txtstyle (getvar "TEXTSTYLE"))
   (setq light$olderr *error* *error* recover)
   (setq scale (GETVAR "DIMSCALE"))
   (setq txtsize 2.5)
   (setq lt_clayer (getvar "CLAYER"))
   (if (<= scale 1E-5)
	   (setq scale 1)
   )
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)
   (SETVAR "TEXTSTYLE" "HZ")
   (initget 1)
   (SETQ p1 (GETPOINT "\n:"))
   (initget 1)
   (SETQ p2 (GETPOINT p1 "\nڶ:"))
   (initget 1)
   (setvar "ORTHOMODE" 1)
   (SETQ p3 (GETPOINT p2 "\n߷:"))
   (setvar "ORTHOMODE" light$othmode)
   (princ "\nָ߶(ͼֽߴ)<") (prin1 txtsize) (princ ">:")
   (setq txth (getreal))
   (if (= txth nil)
       (setq txth 2.5)
   )
   (SETQ txth (* txth scale))
   (SETQ txt (getstring T "\n˵:"))
   (setq a1 (angle p1 p2))
   (setq a0 0.0)
   (if (and (> a1 1.5708) (<= a1 3.14159))   ;90 < a1 <= 180
       (setq a0 1.5708)
   )
   (if (and (> a1 3.14159) (<= a1 4.71239))   ;180 < a1 <= 270
       (setq a0 3.14159)
   )
   (if (and (> a1 4.71239) (<= a1 6.28319))   ;270 < a1 <= 360
       (setq a0 4.71239)
   )
   (setq a1 (- a1 a0))
   (setq a2 0.0)
   (if (and (> a1 0.261799) (<= a1 0.654498))   ;15 < a1 <= 37.5
       (setq a2 0.523599)
   )
   (if (and (> a1 0.654498) (<= a1 0.916298))   ;37.5 < a1 <= 52.5
       (setq a2 0.785398)
   )
   (if (and (> a1 0.916298) (<= a1 1.309))      ;52.5 < a1 <= 75
       (setq a2 1.0472)
   )
   (if (and (> a1 1.309) (<= a1 1.5708))        ;75 < a1 <= 90
	   (setq a2 1.5708)
   )
   (setq a1 (+ a1 a0))
   (setq a2 (+ a2 a0))
   (setq x (- (car p2) (car p1)))
   (setq y (- (cadr p2) (cadr p1)))
   (setq dist (sqrt (+ (* x x) (* y y))))
   (setq p2c (polar p1 a2 dist))
   (setq disttxt (* txth (hztxtnum txt)))
   (setq a3 0.0)
   (setq ptxt (polar p2c 0.0 (/ disttxt 2)))
   (if (> (car p2) (car p3))
       (progn
       (setq a3 pi)
       (setq ptxt (polar p2c pi (/ disttxt 2)))
       )
   )
   (setq ptxt (polar ptxt 1.5708 (/ txth 3)))
   (setq p3c (polar p2c a3 disttxt))
   (setvar "OSMODE" 0)
   (command "_layer" "_make" "SYMBOLS$" "")
   (command "_line" p1 p2c p3c "")
   (command "_text" "_j" "_c" ptxt txth 0 txt)
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "ORTHOMODE" light$othmode)
   (SETVAR "TEXTSTYLE" light$txtstyle)
   (SETQ *error* light$olderr)
   (command "_layer" "s" "0" "")
   (princ)
)
;------------------------------------LT2----------------------------------
(DEFUN C:ts_dtlsym6( / scale txtsize txth p0 p1 p2 p2c p3 ptxt txt a3 disttxt plist num i)
   (setq light$osmode (getvar "OSMODE"))
   (setq light$cmd (GETVAR "CMDECHO"))
   (setq light$blip (GETVAR "BLIPMODE"))
   (setq light$osmode (GETVAR "OSMODE"))
   (setq light$othmode (getvar "ORTHOMODE"))
   (setq light$txtstyle (getvar "TEXTSTYLE"))
   (setq light$olderr *error* *error* recover)
   (setq scale (GETVAR "DIMSCALE"))
   (setq txtsize 2.5)
   (setq lt_clayer (getvar "CLAYER"))
   (if (<= scale 1E-5)
	   (setq scale 1)
   )
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)
   (initget 1)
   (SETVAR "TEXTSTYLE" "HZ")
   (SETQ p1 (GETPOINT "\n:"))
   (setq num 0)
   (setq plist nil)
   (setq plist (cons p1 plist))
   (while (/= p1 nil)
       (setq p0 p1)
       (setq num (+ num 1))
       (initget 0)
       (SETQ p1 (GETPOINT p1 "\n<˳>:"))
       (setq plist (cons p1 plist))
   )
   (initget 1)
   (SETQ p2 (GETPOINT "\nյ:"))
   (initget 1)
   (setvar "ORTHOMODE" 1)
   (SETQ p3 (GETPOINT p2 "\n߷:"))
   (setvar "ORTHOMODE" light$othmode)
   (princ "\nָ߶(ͼֽߴ)<") (prin1 txtsize) (princ ">:")
   (setq txth (getreal))
   (if (= txth nil)
       (setq txth 2.5)
   )
   (SETQ txth (* txth scale))
   (SETQ txt (getstring T "\n˵:"))
   (setq i 1)
   (while (<= i num)
       (setq p1 (nth i plist))
       (setvar "OSMODE" 0)
       (command "_layer" "_make" "SYMBOLS$" "")
       (command "_line" p1 p2 "")
       (setq i (+ i 1))
   )
   (setq disttxt (* txth (hztxtnum txt)))
   (setq a3 0.0)
   (setq ptxt (polar p2 0.0 (/ disttxt 2)))
   (if (> (car p2) (car p3))
       (progn
       (setq a3 pi)
       (setq ptxt (polar p2 pi (/ disttxt 2)))
       )
   )
   (setq ptxt (polar ptxt 1.5708 (/ txth 3)))
   (setq p3c (polar p2 a3 disttxt))
   (command "_line" p2 p3c "")
   (command "_text" "_j" "_c" ptxt txth 0 txt)
   (command "_layer" "s" "0" "")
   (setvar "OSMODE" light$osmode)
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "ORTHOMODE" light$othmode)
   (SETVAR "TEXTSTYLE" light$txtstyle)
   (SETQ *error* light$olderr)
   (princ)
)
;------------------------------------LT3----------------------------------
(DEFUN C:ts_dtlsym7( / scale txtsize txth p1 p2 p3 pd1 pd2 ptxt disttxt disttxtmax txtlist num i v)
   (setq light$osmode (getvar "OSMODE"))
   (setq light$cmd (GETVAR "CMDECHO"))
   (setq light$blip (GETVAR "BLIPMODE"))
   (setq light$osmode (GETVAR "OSMODE"))
   (setq light$othmode (getvar "ORTHOMODE"))
   (setq light$txtstyle (getvar "TEXTSTYLE"))
   (setq light$olderr *error* *error* recover)
   (setq scale (GETVAR "DIMSCALE"))
   (setq lt_clayer (getvar "CLAYER"))
   (if (<= scale 1E-5)
	   (setq scale 1)
   )
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)
   (SETVAR "TEXTSTYLE" "HZ")
   (initget 1)
   (SETQ p1 (GETPOINT "\n:"))
   (setq pd1 p1)
   (initget 1)
   (setvar "ORTHOMODE" 1)
   (SETQ p2 (GETPOINT p1 "\nڶ:"))
   (setq pd2 p2)
   (if (= (cadr p1) (cadr p2))
       (SETQ pd2 (GETPOINT p2 "\nȡ:"))
   )
   (setvar "ORTHOMODE" light$othmode)
   (princ "\nָ߶(ͼֽߴ)<2.5>:")
   (setq txth (getreal))
   (if (= txth nil)
       (setq txth 2.5)
   )
   (SETQ txth (* txth scale))
   (SETQ txt (getstring T "\n1˵:"))
   (setq num 1)
   (setq txtlist nil)
   (setq txtlist (cons txt txtlist))
   (while (/= txt "")
       (setq num (+ num 1))
       (princ "\n") (prin1 num) (princ "˵<˳>:")
       (initget 0)
       (SETQ txt (getstring T))
       (setq txtlist (cons txt txtlist))
   )
   (setvar "OSMODE" 0)
   (command "_layer" "_make" "SYMBOLS$" "")
   (command "_line" p1 p2 "")
   (setq disttxtmax 0)
   (setq i 1)
   (setq num (- num 1))
   (while (<= i num)
       (setq txt (nth i txtlist))
       (setq disttxt (* (* txth 1.2) (hztxtnum txt)))
       (if (< disttxtmax disttxt)
           (setq disttxtmax (+ disttxt txth))
       )
       (setq i (+ i 1))
   )
   (setq v (* txth 2))
   (if (> (cadr pd1) (cadr pd2))
       (progn
           (setq v (* txth -2))
           (setq i num)
           (while (> i 0)
               (setq txt (nth i txtlist))
               (setq p3 (polar p2 1.5708 v))
               (command "_line" p2 p3 "")
               (setq p2 p3)
               (setq p3 (polar p2 0.0 disttxtmax))
               (setq ptxt (polar p2 (/ (* 20 pi) 180) (* txth 1.5)))
               (command "_line" p2 p3 "")
               (command "_text" ptxt txth 0 txt)
               (setq i (- i 1))
           )
       )
       (progn
          (setq i 1)
          (while (<= i num)
              (setq txt (nth i txtlist))
              (setq p3 (polar p2 1.5708 v))
              (command "_line" p2 p3 "")
              (setq p2 p3)
              (setq p3 (polar p2 0.0 disttxtmax))
              (setq ptxt (polar p2 (/ (* 20 pi) 180) (* txth 1.5)))
              (command "_line" p2 p3 "")
              (command "_text" ptxt txth 0 txt)
              (setq i (+ i 1))
          )
       )
   )
   (command "_layer" "s" "0" "")
   (setvar "OSMODE" light$osmode)
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "ORTHOMODE" light$othmode)
   (SETVAR "TEXTSTYLE" light$txtstyle)
   (SETQ *error* light$olderr)
   (princ)
)

;------------------------------------LT4----------------------------------
(DEFUN C:ts_dtlsym8( / scale p1 p2 a1 ps pe dist1 dist2)
   (setq light$osmode (getvar "OSMODE"))
   (setq light$cmd (GETVAR "CMDECHO"))
   (setq light$blip (GETVAR "BLIPMODE"))
   (setq light$osmode (GETVAR "OSMODE"))
   (setq light$othmode (getvar "ORTHOMODE"))
   (setq light$olderr *error* *error* recover)
   (setq scale (GETVAR "DIMSCALE"))
   (setq lt_clayer (getvar "CLAYER"))
   (if (<= scale 1E-5)
	   (setq scale 1)
   )
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)
   (initget 1)
   (SETQ p1 (GETPOINT "\n:"))
   (initget 1)
   (setvar "ORTHOMODE" 1)
   (SETQ p2 (GETPOINT p1 "\nյ:"))
   (setvar "ORTHOMODE" light$othmode)
   (initget 1)
   (setvar "OSMODE" 0)
   (command "_layer" "_make" "SYMBOLS$" "")
   (setq a1 (angle p1 p2))
   (command "_linetype" "_set" "dashdotx2" "")
   (command "_line" p1 p2 "")
   (command "_linetype" "_set" "continuous" "")
   (setq dist1 (* 8 scale))
   (setq dist2 (* 3 scale))
   (setq ps (polar p1 (+ a1 0.872665) dist1))
   (setq pe (polar p1 (- a1 0.872665) dist1))
   (command "_line" ps pe "")
   (setq ps (polar ps a1 dist2))
   (setq pe (polar pe a1 dist2))
   (command "_line" ps pe "")
   (setq ps (polar p2 (+ a1 2.26893) dist1))
   (setq pe (polar p2 (- a1 2.26893) dist1))
   (command "_line" ps pe "")
   (setq ps (polar ps (+ a1 pi) dist2))
   (setq pe (polar pe (+ a1 pi) dist2))
   (command "_line" ps pe "")
   (setvar "OSMODE" light$osmode)
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "ORTHOMODE" light$othmode)
   (command "_layer" "s" "0" "")
   (SETQ *error* light$olderr)
   (princ)
)
;----------------------------LT5----------------------------------------------
(DEFUN C:ts_dtlsym9( / scale txtsize txth p1 p2 pm p3 pd1 pd2 pd3 pd4 ptxt txt a1 a2 dist1 dist2 dist3 disttxt)
   (setq light$osmode (getvar "OSMODE"))
   (setq light$cmd (GETVAR "CMDECHO"))
   (setq light$blip (GETVAR "BLIPMODE"))
   (setq light$osmode (GETVAR "OSMODE"))
   (setq light$othmode (getvar "ORTHOMODE"))
   (setq txtsize 2.5)
   (setq lightt$olderr *error* *error* recover)
   (setq scale (GETVAR "DIMSCALE"))
   (setq lt_clayer (getvar "CLAYER"))
   (if (<= scale 1E-5)
	   (setq scale 1)
   )
   (SETVAR "CMDECHO" 0)
   (SETVAR "BLIPMODE" 0)
   (initget 1)
   (SETQ p1 (GETPOINT "\n:"))
   (initget 1)
   (SETQ p2 (GETPOINT p1 "\nյ:"))
   (setq a1 (angle p1 p2))
   (setq dist1 (/ (distance p1 p2) 2))
   (setq pm (polar p1 a1 dist1))
   (setvar "ORTHOMODE" 1)
   (initget 1)
   (SETQ p3 (GETPOINT p2 "\nһ:"))
   (setvar "ORTHOMODE" light$othmode)
   (princ "\nָ߶(ͼֽߴ)<2.5>:")
   (setq txth (getreal))
   (if (= txth nil)
       (setq txth 2.5)
   )
   (SETQ txth (* txth scale))
   (SETQ txt (getstring T "\n:"))

   (setvar "OSMODE" 0)
   (command "_layer" "_make" "SYMBOLS$" "")

   (setq dist2 (* 3 scale))
   (setq dist3 (* 5 scale))
   (setq pd1 (polar p1 a1 (- dist1 dist2)))
   (setq pd2 (polar pm (- a1 1.5708) dist3))
   (setq pd3 (polar pm (+ a1 1.5708) dist3))
   (setq pd4 (polar pm a1 dist2))
   (command "_line" p1 pd1 pd2 pd3 pd4 p2 "")
   (setq disttxt (+ (/ (* (* txth 1.2) (hztxtnum txt)) 2) txth))
   (setq a2 (angle pm p3))
   (if (< a1 a2)
       (progn
          (setq ptxt (polar p1 (+ a1 1.5708) disttxt))
          (command "_text" "_mc" ptxt txth 0 txt)
       )
       (progn
          (setq ptxt (polar p1 (- a1 1.5708)  disttxt))
          (command "_text" "_mc" ptxt txth 0 txt)
       )
   )
   (if (< a1 a2)
       (progn
          (setq ptxt (polar p2 (+ a1 1.5708) disttxt))
          (command "_text" "_mc" ptxt txth 0 txt)
       )
       (progn
          (setq ptxt (polar p2 (- a1 1.5708) disttxt))
          (command "_text" "_mc" ptxt txth 0 txt)
       )
   )
   (command "_layer" "s" "0" "")
   (setvar "OSMODE" light$osmode)
   (SETVAR "CMDECHO" light$cmd)
   (SETVAR "BLIPMODE" light$blip)
   (SETVAR "ORTHOMODE" light$othmode)
   (SETQ *error* light$olderr)
   (princ)
)
(setq light$symble T)
(menucmd "$S=X")
(menucmd "$S=ts_symble")
(princ)

(defun get_data( / code1 code2 stdcode addb dcl_id data_list dlgf)

   (setq code1 "1" addb 0)
   (setq dlgf (strcat (ts_getenv "DCLS") "dtlsym"))
   (setq dcl_id (load_dialog dlgf))
   (new_dialog "detail1" dcl_id)
   (set_tile "code_t" "1")
   (action_tile "code_t" "(setq code1 (get_tile \"code_t\"))")
   (action_tile "code_t" "(setq code1 $value)")
   (action_tile "code_b" "(setq code2 $value)")
   (action_tile "std_code" "(setq stdcode $value)")
   (action_tile "break" "(setq addb $value)")
   (action_tile "accept" "(get_detail1)")
   (start_dialog)
   (unload_dialog dcl_id)
   (setq data_list (list code1 code2 stdcode addb))
   (setq data_list (list code1 code2 stdcode addb))
)

